// Autor: Stjepan Glavina

#include <cstdio>
#include <cstring>
#include <cassert>

#include <algorithm>
#include <iostream>
using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)
#define TRACE(x) cout << #x << " = " << x << endl
#define _ << " _ " <<

typedef long long llint;

const int MAX = 3932160;
const int oo = 1e6;

int cnt[15][4];
int a[4], b[4];

int memo[MAX];
int how[2][15][4];

string card(int r, int c) {
  return to_string(r) + "KHTP"[c];
}

int rec(int r, int c, bool recon) {
  if (c == 4) {
    int sum = 0;
    REP(i, 4) sum += cnt[r][i] - (a[i]>0) - (b[i]>0);
    return rec(r+1, 0, recon) + sum * (sum >= 3);
  }
  if (r == 15) return 0;

  int state = r*4 + c;
  REP(i, 4) state = state*4 + a[i];
  REP(i, 4) state = state*4 + b[i];

  assert(state >= 0 && state < MAX);
  if (!recon && memo[state] != -1) return memo[state];

  int ret = -oo;
  
  REP(x, 2) REP(y, 2) {
    if (cnt[r][c] < x + y) continue;
    if (a[c] && a[c] < 3 && !x) continue;
    if (b[c] && b[c] < 3 && !y) continue;
    
    int old_a = a[c];
    int old_b = b[c];
    if (x == 0) assert(a[c] == 0 || a[c] >= 3);
    if (x == 0) assert(a[c] == 0 || a[c] >= 3);

    a[c] = min((a[c] + 1) * x, 3);
    b[c] = min((b[c] + 1) * y, 3);

    int w = rec(r, c+1, false) + x + y;
    ret = max(ret, w);

    if (recon && w == memo[state]) {
      how[0][r][c] = x;
      how[1][r][c] = y;
      rec(r, c+1, true);

      a[c] = old_a;
      b[c] = old_b;
      return ret;
    }

    a[c] = old_a;
    b[c] = old_b;
  }

  return memo[state] = ret;
}

int main() {
  int M; scanf("%d", &M);
  while (M--) {
    memset(cnt, 0, sizeof cnt);

    int N; scanf("%d", &N);
    while (N--) {
      int r; char c; scanf("%d%c", &r, &c);
      REP(i, 4) if (c == "KHTP"[i]) ++cnt[r][i];
    }

    memset(memo, -1, sizeof memo);
    memset(how, 0, sizeof how);
    REP(i, 4) a[i] = b[i] = 0;

    int ans = rec(0, 0, false);
    printf("%d", ans);

    if (ans) {
      rec(0, 0, true);
      string out = "";
      
      REP(t, 2) REP(c, 4) REP(r, 15) if (how[t][r][c]) {
        if (how[t][r-1][c] == 0) out += " |";
        out += " " + card(r, c);
      }

      REP(r, 15) {
        vector<string> cards;
        REP(c, 4) {
          int num = cnt[r][c] - how[0][r][c] - how[1][r][c];
          REP(i, num) cards.push_back(card(r, c));
        }

        if (cards.size() >= 3) {
          out += " |";
          for (string s : cards) out += " " + s;
        }
      }

      printf("%s", out.substr(2).c_str());
    }
    puts("");
  }
  return 0;
}
